<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PointUser extends Model 
{

    protected $table = 'point_users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function pointeable()
    {
        return $this->morphTo();
    }

    public function user_id()
    {
        return $this->belongsTo('App\Models\User');
    }

}